/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public abstract class ServerBoundPacketHandler<D> {
    protected ResourceLocation CHANNEL;

    public static <D, T extends ServerBoundPacketHandler<D>> T register(ResourceLocation channel, T packetHandler) {
        packetHandler.CHANNEL = channel;
        ServerPlayConnectionEvents.INIT.register((handler, server) -> ServerPlayNetworking.registerReceiver((ServerGamePacketListenerImpl)handler, (ResourceLocation)packetHandler.CHANNEL, packetHandler::receiveOnServer));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerPlayNetworking.unregisterReceiver((ServerGamePacketListenerImpl)handler, (ResourceLocation)packetHandler.CHANNEL));
        return packetHandler;
    }

    public void sendToServer(D content) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this._sendToServer(content);
        }
    }

    private void _sendToServer(D content) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        this.serializeOnClient(buf, content);
        ClientPlayNetworking.send((ResourceLocation)this.CHANNEL, (FriendlyByteBuf)buf);
    }

    void receiveOnServer(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf, PacketSender responseSender) {
        D content = this.deserializeOnServer(buf, player, responseSender);
        server.execute(() -> this.processOnGameThread(server, player, content));
    }

    protected abstract void serializeOnClient(FriendlyByteBuf var1, D var2);

    protected abstract D deserializeOnServer(FriendlyByteBuf var1, ServerPlayer var2, PacketSender var3);

    protected abstract void processOnGameThread(MinecraftServer var1, ServerPlayer var2, D var3);

    protected void onRegister() {
    }
}

